<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
// 1. PRIMERO LA LÓGICA (Sin salida de texto/HTML)
require_once '../config/db.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }

// SEGURIDAD PRO: Bloqueo para editores
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header("Location: dashboard.php?error=access_denied");
    exit;
}
// Obtener datos del usuario
$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: usuarios.php");
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$id]);
$u = $stmt->fetch(PDO::FETCH_ASSOC);

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $role = $_POST['role'];
    $phone = $_POST['phone'];
    
    if (!empty($_POST['password'])) {
        $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $sql = "UPDATE users SET full_name=?, email=?, password_hash=?, role=?, phone=? WHERE id=?";
        $pdo->prepare($sql)->execute([$full_name, $email, $pass, $role, $phone, $id]);
    } else {
        $sql = "UPDATE users SET full_name=?, email=?, role=?, phone=? WHERE id=?";
        $pdo->prepare($sql)->execute([$full_name, $email, $role, $phone, $id]);
    }
    
    // Ahora la redirección funciona porque no hay HTML arriba
    header("Location: usuarios.php?status=updated");
    exit;
}

// 2. DESPUÉS LOS INCLUDES DE VISTA (HTML)
require_once 'includes/header.php';
require_once 'includes/sidebar.php';
?>

<div class="flex-1 flex flex-col h-full overflow-hidden relative">
    <?php require_once 'includes/navbar.php'; ?>

    <main class="flex-1 overflow-x-hidden overflow-y-auto bg-brand-light dark:bg-[#080808] p-4 md:p-8">
        <div class="max-w-3xl mx-auto">
            <div class="flex items-center gap-4 mb-8">
                <a href="usuarios.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-brand-dark border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-all shadow-sm">
                    <i class="ri-arrow-left-line text-xl"></i>
                </a>
                <div>
                    <span class="text-brand-red font-black text-[10px] uppercase tracking-widest">Gestión de Accesos</span>
                    <h1 class="font-display font-black text-3xl dark:text-white uppercase tracking-tighter">Editar Usuario</h1>
                </div>
            </div>

            <form method="POST" class="bg-white dark:bg-brand-dark p-8 md:p-12 rounded-[2.5rem] border border-gray-100 dark:border-white/5 shadow-2xl space-y-8">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Nombre Completo</label>
                        <input type="text" name="full_name" value="<?php echo htmlspecialchars($u['full_name']); ?>" required 
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                    </div>
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Correo Corporativo</label>
                        <input type="email" name="email" value="<?php echo htmlspecialchars($u['email']); ?>" required 
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Nueva Contraseña</label>
                        <input type="password" name="password" placeholder="••••••••"
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                        <p class="text-[9px] text-gray-500 italic ml-1">* Dejar en blanco para mantener la actual</p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Privilegios de Sistema</label>
                        <select name="role" class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white outline-none focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red transition-all cursor-pointer">
                            <option value="editor" <?php echo $u['role'] == 'editor' ? 'selected' : ''; ?>>Editor de Contenido</option>
                            <option value="admin" <?php echo $u['role'] == 'admin' ? 'selected' : ''; ?>>Administrador Master</option>
                        </select>
                    </div>
                </div>

                <div class="space-y-2">
                    <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Teléfono / WhatsApp</label>
                    <input type="text" name="phone" value="<?php echo htmlspecialchars($u['phone']); ?>" 
                           class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-black uppercase py-5 rounded-2xl shadow-xl shadow-brand-red/30 transition-all transform active:scale-[0.98] tracking-widest">
                        Guardar Cambios del Usuario
                    </button>
                </div>
            </form>
        </div>
    </main>
</div>

<?php require_once 'includes/footer.php'; ?>